<?php

require_once 'Modele/Modele.php';

/**
 * Classe modélisant un utilisateur
 *
 * @author thibaultfloquet
 */
class ModeleUtilisateur extends Modele
{
    public function lireToutLesUtilisateurs()
    {
        return $this->executerLecture('select * from UTILISATEUR order by NUMUTILISATEUR');
    }
    
    public function lireUnSeulUtilisateurId($id)
    {
        return $this->executerLecture('select * from UTILISATEUR UT join DROIT DR on UT.NUMDROIT = DR.NUMDROIT where NUMUTILISATEUR=' . $id, true);
    }
    
    public function lireUnSeulUtilisateurPseudo($pseudo)
    {
        return $this->executerLecture("select * from UTILISATEUR UT join DROIT DR on UT.NUMDROIT = DR.NUMDROIT where PSEUDOUTILISATEUR= '$pseudo'", true);
    }
    
    public function lireUtilisateurPseudoMdp($pseudo, $mdp)
    {
        return $this->executerLecture("select * from UTILISATEUR UT join DROIT DR on UT.NUMDROIT = DR.NUMDROIT where PSEUDOUTILISATEUR= '$pseudo' and MDPUTILISATEUR= '$mdp'", true);
    }
    
    public function compterNombreMessagesUtilisateur($id)
    {
        return $this->executerLecture('select COUNT(*) as nbMessages from UTILISATEUR UT join MESSAGE ME on UT.NUMUTILISATEUR = ME.NUMUTILISATEUR where UT.NUMUTILISATEUR=' . $id, true);
    }
    
    public function compterNombreUtilisateurs()
    {
        return $this->executerLecture('select COUNT(*) as nbUtilisateurs from UTILISATEUR', true);
    }
    
    public function dernierUtilisateurInscrit()
    {
        return $this->executerLecture('select * from UTILISATEUR where NUMUTILISATEUR = (select MAX(NUMUTILISATEUR) from UTILISATEUR)', true);
    }

    public function ajouterUtilisateur($pseudo, $mdp, $email, $droits = 2)
    {
        $date = date(DATE_W3C);
        if($droits != 2)
            $droits = 1;
        $this->executerModification('insert into UTILISATEUR(PSEUDOUTILISATEUR, MDPUTILISATEUR, EMAILUTILISATEUR, DATEINSCRIPTION, NUMDROIT) values (?, ?, ?, ?, ?)',
            array($pseudo, $mdp, $email, $date, $droits));
    }
    
    public function supprimerUtilisateur($numUtilisateur)
    {
        $this->executerModification('delete from UTILISATEUR where NUMUTILISATEUR = ?', array($numUtilisateur));
    }
}
