<?php

require_once 'Modele/Modele.php';

/**
 * Classe modélisant un sujet de forum
 *
 * @author thibaultfloquet
 */
class ModeleSujet extends Modele
{
    public function lireToutLesSujetsDuForum($id)
    {
        return $this->executerLecture('select * from SUJET SU join UTILISATEUR UT ON SU.NUMUTILISATEUR = UT.NUMUTILISATEUR where NUMFORUM ='.$id.' order by DATECREATIONSUJET desc');
    }
    
    public function compterNombreDeReponsesSujet($id)
    {
        return $this->executerLecture('select COUNT(*) as nbResponsesSujet from SUJET SU join MESSAGE ME on SU.NUMSUJET = ME.NUMSUJET where SU.NUMSUJET=' . $id, true);
    }
    
    public function compterNombreDeConsultationsSujet($id)
    {
        return $this->executerLecture('select SUM(NBCONSULTATIONSSUJET) as nbConsultationsSujet from SUJET where NUMSUJET=' . $id, true);
    }
    
    public function compterNombreTotalSujets()
    {
        return $this->executerLecture('select COUNT(*) as nbTotalSujets from SUJET', true);
    }
    
   public function compterSujetsForum($id)
    {
        return $this->executerLecture('select COUNT(*) as nbSujetsRestant from SUJET where NUMFORUM=' . $id, true);
    }
    
    public function dernierSujetInsert()
    {
        return $this->executerLecture('select last_insert_id() as lid from SUJET' , true);
    }
    
    public function incrementerCompteurConsultation($id)
    {
        $this->executerModification('update SUJET SET NBCONSULTATIONSSUJET = NBCONSULTATIONSSUJET+1 WHERE NUMSUJET= ?',
            array($id));
    }

    public function ajouterSujet($numForum, $numUtilisateur, $titreSujet)
    {
        $date = date(DATE_W3C);
        $this->executerModification('insert into SUJET(NUMFORUM, NUMUTILISATEUR, TITRESUJET, DATECREATIONSUJET) values (?,?,?,?)',
            array($numForum, $numUtilisateur, $titreSujet, $date));
    }
    
    public function supprimerSujet($numSujet)
    {
        $this->executerModification('delete from SUJET where NUMSUJET = ?',
            array($numSujet));
    }
}
