<?php

require_once 'Modele/Modele.php';

/**
 * Classe modélisant un forum
 *
 * @author thibaultfloquet
 */
class ModeleForum extends Modele
{
    public function lireToutLesForums()
    {
        return $this->executerLecture('select * from FORUM order by NUMFORUM');
    }
   
    public function lireUnSeulForum($id)
    {
        return $this->executerLecture('select * from FORUM where NUMFORUM=' . $id, true);
    }
    
    public function lireToutLesForumsCategorie($id)
    {
        return $this->executerLecture('select * from FORUM where NUMCATEGORIE='.$id.' order by NUMFORUM');
    }
    
    public function compterNombreDeSujetsForum($id)
    {
        return $this->executerLecture('select COUNT(*) as nbSujetsForum from FORUM FO join SUJET SU on FO.NUMFORUM = SU.NUMFORUM where FO.NUMFORUM=' . $id, true);
    }
    
    public function compterForumsCategorie($id)
    {
        return $this->executerLecture('select COUNT(*) as nbForumsRestant from FORUM where NUMCATEGORIE=' . $id, true);
    }
    
    public function compterNombreDeMessagesForum($id)
    {
        return $this->executerLecture('select COUNT(*) as nbMessagesForum from FORUM FO join SUJET SU on FO.NUMFORUM = SU.NUMFORUM join MESSAGE ME on SU.NUMSUJET = ME.NUMSUJET  where FO.NUMFORUM=' . $id, true);
    }
    
    public function dernierForumInsert()
    {
        return $this->executerLecture('select last_insert_id() as lid from FORUM' , true);
    }

    public function recupererDernierMessageForum($id)
    {
        $lastInsert = $this->executerLecture('select MAX(NUMMESSAGE) as lid from MESSAGE ME join SUJET SU on SU.NUMSUJET = ME.NUMSUJET join FORUM FO on SU.NUMFORUM = FO.NUMFORUM where FO.NUMFORUM=' . $id, true);
        return $this->executerLecture('select * from MESSAGE ME join UTILISATEUR UT on ME.NUMUTILISATEUR = UT.NUMUTILISATEUR where ME.NUMMESSAGE=' . $lastInsert['lid'], true);
    }

    public function ajouterForum($titreForum, $descriptionForum, $numCategorie)
    {
        $date = date(DATE_W3C);
        $this->executerModification('insert into FORUM (TITREFORUM, DESCRIPTIONFORUM, DATECREATIONFORUM, NUMCATEGORIE) values (?,?,?,?)',
            array($titreForum, $descriptionForum, $date, $numCategorie));
    }
    
    public function supprimerForum($numForum)
    {
        $this->executerModification('delete from FORUM where NUMFORUM = ?',
            array($numForum));
    }
}