<?php

require_once 'Modele/Modele.php';

/**
 * Classe modélisant une catégorie de forum
 *
 * @author thibaultfloquet
 */

class ModeleCategorie extends Modele
{
    public function lireToutesLesCategories()
    {
        return $this->executerLecture('select * from CATEGORIE order by NUMCATEGORIE');
    }
    
    public function lireUneSeuleCategorie($id)
    {
        return $this->executerLecture('select * from CATEGORIE where NUMCATEGORIE=' . $id, true);
    }
    
    public function ajouterCategorie($titreCategorie)
    {
        $this->executerModification('insert into CATEGORIE(TITRECATEGORIE) values (?)',
            array($titreCategorie));
    }
    
    public function supprimerCategorie($numCategorie)
    {
        $this->executerModification('delete from CATEGORIE where NUMCATEGORIE = ?',
            array($numCategorie));
    }
}
