<?php

require_once 'Modele/ModeleUtilisateur.php';
require_once 'Controleur/Controleur.php';

/**
 * Contrôleur des actions liées aux utilisateurs
 *
 * @author thibaultfloquet
 */
class ControleurUtilisateur extends Controleur
{
    private $modeleUtilisateur;
    
    public function __construct()
    {
        $this->modeleUtilisateur = new ModeleUtilisateur();
    }
    
    public function listerInformationsUtilisateur($id)
    {
        $utilisateur = $this->modeleUtilisateur->lireUnSeulUtilisateurId($id);
        
        $dateNonFormatIncription = strtotime($utilisateur['DATEINSCRIPTION']);                
        $utilisateur['dateFormatIncription'] = date('d M Y à H\hi', $dateNonFormatIncription);
        $this->genererVue('afficheUtilisateur',
                array('utilisateur' => $utilisateur));
    }
    
    public function listerInformationsUtilisateurPseudo($pseudo)
    {
        $utilisateur = $this->modeleUtilisateur->lireUnSeulUtilisateurPseudo($pseudo);
        $dateNonFormatIncription = strtotime($utilisateur['DATEINSCRIPTION']);                
        $utilisateur['dateFormatIncription'] = date('d M Y à H\hi', $dateNonFormatIncription);
        $_SESSION['idUtilisateur'] = $utilisateur['NUMUTILISATEUR'];
        $_SESSION['pseudoUtilisateur'] = $utilisateur['PSEUDOUTILISATEUR'];
        $_SESSION['emailUtilisateur'] = $utilisateur['EMAILUTILISATEUR'];
        $_SESSION['droitUtilisateur'] = $utilisateur['NUMDROIT'];
        $this->genererVue('afficheUtilisateur',
                array('utilisateur' => $utilisateur));
    }
    
    public function afficherInscription()
    {
        $this->genererVue('inscriptionUtilisateur',
                array());
    }
    
    public function afficherConnexion()
    {
        $this->genererVue('connexionUtilisateur',
                array());
    }
    
    public function ajouterUtilisateur($pseudo, $mdp, $email) 
    {
        $this->modeleUtilisateur->ajouterUtilisateur($pseudo, $mdp, $email);
        $this->listerInformationsUtilisateurPseudo($pseudo);
    }
    
    public function ajouterUtilisateurAdmin($pseudo, $mdp, $email) 
    {
        $this->modeleUtilisateur->ajouterUtilisateur($pseudo, $mdp, $email, 1);
        $this->listerInformationsUtilisateurPseudo($pseudo);
    }
    
    public function supprimerUtilisateur($id)
    {
        $this->modeleUtilisateur->supprimerUtilisateur($id);
        session_destroy();
        unset($_SESSION['idUtilisateur']);
        unset($_SESSION['pseudoUtilisateur']);
        unset($_SESSION['emailUtilisateur']);
        unset($_SESSION['droitUtilisateur']);
    }

    public function deconnecterUtilisateur()
    {
        session_destroy();
        unset($_SESSION['idUtilisateur']);
        unset($_SESSION['pseudoUtilisateur']);
        unset($_SESSION['emailUtilisateur']);
        unset($_SESSION['droitUtilisateur']);
    }

    public function verifierConnecterUtilisateur($pseudo, $mdp)
    {
        $utilisateur = $this->modeleUtilisateur->lireUtilisateurPseudoMdp($pseudo, $mdp);
        if(($utilisateur['PSEUDOUTILISATEUR'] === $pseudo and $utilisateur['MDPUTILISATEUR'] === $mdp))
        {
            $_SESSION['idUtilisateur'] = $utilisateur['NUMUTILISATEUR'];
            $_SESSION['pseudoUtilisateur'] = $utilisateur['PSEUDOUTILISATEUR'];
            $_SESSION['emailUtilisateur'] = $utilisateur['EMAILUTILISATEUR'];
            $_SESSION['droitUtilisateur'] = $utilisateur['NUMDROIT'];
            $dateNonFormatIncription = strtotime($utilisateur['DATEINSCRIPTION']);                
            $utilisateur['dateFormatIncription'] = date('d M Y à H\hi', $dateNonFormatIncription);
            $this->genererVue('afficheUtilisateur',
                array('utilisateur' => $utilisateur));
        }
        
        else
        {
            $_SESSION['erreur'] = "Identifiants incorrects !";
            $this->afficherConnexion();
        }
    }
    
    public function recupererUtilisateur($id)
    {
        return $this->modeleUtilisateur->lireUnSeulUtilisateurId($id);
    }
}