<?php

require_once 'Modele/ModeleSujet.php';
require_once 'Controleur/Controleur.php';

/**
 * Contrôleur des actions liées aux sujets
 *
 * @author thibaultfloquet
 */
class ControleurSujet extends Controleur
{
    private $modeleSujet;
    private $modeleForum;
    
    public function __construct()
    {
        $this->modeleSujet = new ModeleSujet();
        $this->modeleForum = new ModeleForum();
    }
    
    public function listerSujetsForum($id)
    {
        $_SESSION['arianeIdMessage'] = $id; //On definit l'ID du sujet courant pour le fil d'ariane
        $sujets = $this->modeleSujet->lireToutLesSujetsDuForum($id);
        
        $resultatsSujets = $sujets->fetchAll();
        
        foreach ($resultatsSujets as &$sujet)
        {
            $nbReponsesSujet = $this->modeleSujet->compterNombreDeReponsesSujet($sujet['NUMSUJET']);
            $nbConsultationsSujet = $this->modeleSujet->compterNombreDeConsultationsSujet($sujet['NUMSUJET']);
            $sujet['nbReponsesSujet'] = $nbReponsesSujet['nbResponsesSujet'];
            $sujet['nbConsultationsSujet'] = $nbConsultationsSujet['nbConsultationsSujet'];
            $dateNonFormatDernierMessage = strtotime($sujet['DATECREATIONSUJET']);
            $sujet['dateFormatDernierMessage'] = date('d M Y à H\hi', $dateNonFormatDernierMessage);
        }
        
        $lienSuppression = "index.php?action=supprimerSujet&id=";
        $lienMessages = "index.php?action=afficherMessages&id=";
        $lienUtilisateur = "index.php?action=afficherUtilisateur&id=";
        if(isset($_SESSION['idUtilisateur']))
            $lienAjoutSujet = "index.php?action=nouveauSujet";
        else 
            $lienAjoutSujet = "index.php?action=afficherConnexion";
        
        $this->genererVue('listeSujets', 
                array('sujets' => $resultatsSujets, 'lienMessages' => $lienMessages, 'lienUtilisateur' => $lienUtilisateur,'lienAjoutSujet'=>$lienAjoutSujet, 'lienSuppression' => $lienSuppression));
    }
    
    public function incrementerCompteurConsultationSujet($id)
    {
        $this->modeleSujet->incrementerCompteurConsultation($id);
    }
    
    public function afficherNouveauSujet()
    {
        $forums = $this->modeleForum->lireToutLesForums();
        $this->genererVue('nouveauSujet',
                array('forums' => $forums));
    }
    
    public function ajouterSujetAffichage($numForum, $numUtilisateur, $titre)
    {
        $this->modeleSujet->ajouterSujet($numForum, $numUtilisateur, $titre);
        $this->listerSujetsForum($id);
    }
    
    public function ajouterSujet($numForum, $numUtilisateur, $titre)
    {
        $this->modeleSujet->ajouterSujet($numForum, $numUtilisateur, $titre);
    }
    
    public function supprimerSujet($numSujet)
    {
        $this->modeleSujet->supprimerSujet($numSujet);
    }
    
    public function recupererDernierSujetInsert()
    {
        $dernierInsert = $this->modeleSujet->dernierSujetInsert();
        return $dernierInsert['lid'];
    }
    
    public function compterSujetsForum($id)
    {
        return $this->modeleSujet->compterSujetsForum($id); 
    }
}