<?php

require_once 'Modele/ModeleMessage.php';
require_once 'Controleur/Controleur.php';

/**
 * Contrôleur des actions liées aux messages
 *
 * @author thibaultfloquet
 */
class ControleurMessage extends Controleur
{
    private $modeleMessage;
    private $modeleUtilisateur;
    
    public function __construct()
    {
        $this->modeleMessage = new ModeleMessage();
        $this->modeleUtilisateur = new ModeleUtilisateur();
    }
    
    public function listerMessagesSujet($id)
    {
        $resultatsMessages = $this->modeleMessage->lireToutLesMessagesDuSujet($id);
        $messages = $resultatsMessages->fetchAll();
     
        foreach ($messages as &$message) 
        {
            $utilisateur = $this->modeleUtilisateur->lireUnSeulUtilisateurId($message['NUMUTILISATEUR']);
            $nombreMessages = $this->modeleUtilisateur->compterNombreMessagesUtilisateur($message['NUMUTILISATEUR']);
            $message['PSEUDOUTILISATEUR'] = $utilisateur['PSEUDOUTILISATEUR'];
            $message['NUMUTILISATEUR'] = $utilisateur['NUMUTILISATEUR'];
            $message['DROITUTILISATEUR'] = $utilisateur['DROITUTILISATEUR'];
            $message['DATEINSCRIPTION'] = $utilisateur['DATEINSCRIPTION'];
            $message['NOMBREMESSAGES'] = $nombreMessages['nbMessages'];
            
            $dateNonFormatMessage = strtotime($message['DATECREATIONMESSAGE']);
            $dateNonFormatIncription = strtotime($message['DATECREATIONMESSAGE']);

            $message['dateFormatMessage'] = date('d M Y à H\hi', $dateNonFormatMessage);
            $message['dateFormatIncription'] = date('d M Y à H\hi', $dateNonFormatIncription);
        }
       
        $lienSuppression = "index.php?action=supprimerMessage&id=";
        $lienUtilisateur = "index.php?action=afficherUtilisateur&id=";
        $lienAjout = 'index.php?action=afficherConnexion';
        $lienAriane = "index.php?action=afficherSujets&id=";
        
        $this->genererVue('listeMessages', 
                array('messages' => $messages, 'lienSuppression' => $lienSuppression, 'lienUtilisateur' => $lienUtilisateur, 'lienAjout' =>$lienAjout,'lienAriane'=> $lienAriane));
    }
    
    
    public function ajouterMessageAffichage($numUtilisateur, $numSujet, $contenuMessage)
    {
        $this->modeleMessage->ajouterMessage($numUtilisateur, $numSujet, $contenuMessage);
        $this->listerMessagesSujet($numSujet);
    }
    
    public function ajouterMessage($numUtilisateur, $numSujet, $contenuMessage)
    {
        $this->modeleMessage->ajouterMessage($numUtilisateur, $numSujet, $contenuMessage);
    }
    
    public function supprimerMessage($numMessage)
    {
        $this->modeleMessage->supprimerMessage($numMessage);
    }
    
    public function nouveauMessage()
    {
        $this->genererVue('nouveauMessage',
                array());
    }
    
    public function compterMessagesSujet($id)
    {
        return $this->modeleMessage->compterMessagesSujet($id); 
    }
}