<?php

require 'Controleur/ControleurCategorie.php';
require 'Controleur/ControleurSujet.php';
require 'Controleur/ControleurMessage.php';
require 'Controleur/ControleurForum.php';
require 'Controleur/ControleurUtilisateur.php';

/**
 * Description of ControleurFrontal
 *
 * @author thibaultfloquet
 */
class ControleurFrontal extends Controleur {

    private $ctrlForum;
    private $ctrlSujet;
    private $ctrlMessage;
    private $ctrlUtilisateur;
    private $ctrlCategorie;

    public function __construct()
    {
        $this->ctrlForum = new ControleurForum();
        $this->ctrlSujet = new ControleurSujet();
        $this->ctrlMessage = new ControleurMessage();
        $this->ctrlUtilisateur = new ControleurUtilisateur();
        $this->ctrlCategorie = new ControleurCategorie();
    }
    
    public function routerRequete()
    {
        try 
        {
            if (!empty($_POST['inscription'])) {
                $this->routerRequetePostIncription();
            }
            else if (!empty($_POST['connexion'])) {
                $this->routerRequetePostConnexion();
            }
            else if (!empty($_POST['postMessage'])) {
                $this->routerRequetePostMessage();
            }
            else if (!empty($_POST['suppressionCompte'])) {
                $this->routerRequetePostSuppressionCompte();
            }
            else if (!empty($_POST['postForum'])) {
                $this->routerRequetePostNouveauForum();
            }
            else if (!empty($_POST['postSujet'])) {
                $this->routerRequetePostNouveauSujet();
            }
            else if (!empty($_POST['postnouveauMessage'])) {
                $this->routerRequetePostNouveauMessage();
            }
            elseif (!empty($_GET)) {
                $this->routerRequeteGet();
            }
            else {
                $this->ctrlForum->listerForumsAvecCategories();  // action par défaut (affichages des forums)
            }
        }
        catch (Exception $e) 
        {
            $this->afficherErreur($e->getMessage());
        }
    }

    private function routerRequetePostIncription()
    {
        if (!empty($_POST['pseudo'])
                And !empty($_POST['mdp'])
                And !empty($_POST['email'])) {
            // Verification des informations saisies dans la captcha avec clé privée, addresse IP du serveur, et champs du captcha généré par celui-ci
            $reponse = recaptcha_check_answer('6LcD-doSAAAAACGtw1XVcVex_LRAXzTcfS-d-X5S', $_SERVER['REMOTE_ADDR'], $_POST['recaptcha_challenge_field'], $_POST['recaptcha_response_field']);
            if($reponse->is_valid) // Si le captcha est valide
            {
                $pseudo = strip_tags($_POST['pseudo']);
                $mdp = strip_tags($_POST['mdp']);
                $email = strip_tags($_POST['email']);
                $this->ctrlUtilisateur->ajouterUtilisateur($pseudo, $mdp, $email); // On ajoute l'utilisateur
            }
            
            else // Sinon on definit un message d'erreur et on renvoit vers la page d'inscription
            {
                $_SESSION['erreur'] = "Erreur de saisie du captcha ! Vous êtes donc un robot ?";
                $this->ctrlUtilisateur->afficherInscription();
            }
        }
        else
            throw new Exception('Paramètres $_POST non reconnus');
    }
    
    private function routerRequetePostSuppressionCompte()
    {
        if (!empty($_POST['mdp'])
                And !empty($_POST['idUtilisateur'])) {
            $mdp = strip_tags($_POST['mdp']);
            $idUtilisateur = strip_tags($_POST['idUtilisateur']);
            $utilisateur = $this->ctrlUtilisateur->recupererUtilisateur($idUtilisateur);
            if($mdp == $utilisateur['MDPUTILISATEUR'])
            {
                $this->ctrlUtilisateur->supprimerUtilisateur ($idUtilisateur);
                $this->ctrlForum->listerForumsAvecCategories();
            }
            else
            {
                $_SESSION['erreur'] = "Le mot de passe ne correspond pas !";
                $this->ctrlUtilisateur->listerInformationsUtilisateur($idUtilisateur);
            }
        }
        else
            throw new Exception('Paramètres $_POST non reconnus');
    }
    
    private function routerRequetePostConnexion()
    {
        if (!empty($_POST['pseudo'])
                And !empty($_POST['mdp'])) {
            $pseudo = strip_tags($_POST['pseudo']);
            $mdp = strip_tags($_POST['mdp']);
            $this->ctrlUtilisateur->verifierConnecterUtilisateur($pseudo, $mdp);
        }
        else
            throw new Exception('Paramètres $_POST non reconnus');
    }
    
    private function routerRequetePostMessage()
    {
        if (!empty($_POST['ckeditor'])
                And !empty($_POST['idUtilisateur'])
                And !empty($_POST['idSujet'])) {
            $idUtilisateur = strip_tags($_POST['idUtilisateur']);
            $idSujet = strip_tags($_POST['idSujet']);
            //On autorise seulement certaines balises HTML à passer la verification de la fonction strip_tags
            $message = strip_tags($_POST['ckeditor'],'<p><strong><em><u><strike>');
            $this->ctrlMessage->ajouterMessageAffichage($idUtilisateur, $idSujet, $message);
        }
        else {
            $idSujet = strip_tags($_POST['idSujet']);
            $_SESSION['erreur'] = "Veuillez rentrer un message !";
            $this->ctrlMessage->listerMessagesSujet($idSujet);
        }
    }
    
    private function routerRequetePostNouveauForum()
    {
        
        if (!empty($_POST['nomNouveauForum']) And !empty($_POST['idUtilisateur']) 
                And !empty($_POST['descriptionNouveauForum'])
                And !empty($_POST['sujetNouveauForum']) 
                And !empty($_POST['ckeditor'])
                And !empty($_POST['listeCat'])) {
            $nomForum = strip_tags($_POST['nomNouveauForum']);
            $idUtilisateur = strip_tags($_POST['idUtilisateur']);
            $descriptionForum = strip_tags($_POST['descriptionNouveauForum']);
            $sujetForum = strip_tags($_POST['sujetNouveauForum']);
            //On autorise seulement certaines balises HTML à passer la verification de la fonction strip_tags
            $messageSujet = strip_tags($_POST['ckeditor'],'<p><strong><em><u><strike>');
            $numCategorieForum = strip_tags($_POST['listeCat']);
            
            //On ajoute un forum
            $this->ctrlForum->ajouterForum($nomForum, $descriptionForum,$numCategorieForum);
            $dernierIdForum = $this->ctrlForum->recupererDernierForumInsert(); // Récupération du dernier id insert de la table forum
            
            //On ajoute un sujet au forum
            $this->ctrlSujet->ajouterSujet($dernierIdForum, $idUtilisateur, $sujetForum);
            $dernierIdSujet = $this->ctrlSujet->recupererDernierSujetInsert(); // Récupération du dernier id insert de la table sujet
            
            //On ajoute on message a ce sujet
            $this->ctrlMessage->ajouterMessage($idUtilisateur, $dernierIdSujet, $messageSujet);
            $this->ctrlForum->listerForumsAvecCategories(); // Et on affiche les forums
        }
        else {
            $_SESSION['erreur'] = "Veuillez remplir correctement tous les champs !";
            $this->ctrlForum->afficherNouveauForum();
        }
    }
    
    private function routerRequetePostNouveauSujet()
    {
        if (!empty($_POST['titreNouveauSujet']) 
                And !empty($_POST['idUtilisateur'])
                And !empty($_POST['ckeditor'])
                And !empty($_POST['listeForum'])) {
            //On autorise seulement certaines balises HTML à passer la verification de la fonction strip_tags
            $messageSujet = strip_tags($_POST['ckeditor'],'<p><strong><em><u><strike>');
            $titre = strip_tags($_POST['titreNouveauSujet']);
            $idUtilisateur = strip_tags($_POST['idUtilisateur']);
            $numForum  = strip_tags($_POST['listeForum']);
            
            $this->ctrlSujet->ajouterSujet($numForum, $idUtilisateur, $titre);
            $dernierIdSujet = $this->ctrlSujet->recupererDernierSujetInsert();
            $this->ctrlMessage->ajouterMessage($idUtilisateur, $dernierIdSujet, $messageSujet);
            $this->ctrlSujet->listerSujetsForum($numForum);
            
        }
        else {
            $_SESSION['erreur'] = "Veuillez remplir correctement tous les champs !";
            $this->ctrlSujet->afficherNouveauSujet();
        }
    }


    private function routerRequeteGet()
    {
        if (isset($_GET['action'])) {
            
            if ($_GET['action'] == 'afficherSujets') {
                if (isset($_GET['id'])) {
                    $idForum = intval($_GET['id']);
                    if ($idForum != 0)
                        $this->ctrlSujet->listerSujetsForum($idForum);
                    else {
                        $id = strip_tags($_GET['id']);
                        throw new Exception("Identifiant de forum '$id' non valide");
                    }
                }
                else
                    throw new Exception("Identifiant de forum non défini");
            }
            
            
            else if($_GET['action'] == 'afficherMessages') {
                if (isset($_GET['id'])) {
                    $idSujet = intval($_GET['id']);
                    if ($idSujet != 0) {
                        $this->ctrlMessage->listerMessagesSujet($idSujet);
                        $this->ctrlSujet->incrementerCompteurConsultationSujet($idSujet);
                    }
                    
                    else {
                        $id = strip_tags($_GET['id']);
                        throw new Exception("Identifiant de sujet '$id' non valide");
                    }
                }
                else
                    throw new Exception("Identifiant de sujet non défini");
            }
            
            
            else if($_GET['action'] == 'afficherUtilisateur') {
                if (isset($_GET['id'])) {
                    $idUtilisateur = intval($_GET['id']);
                    if ($idUtilisateur != 0)
                        $this->ctrlUtilisateur->listerInformationsUtilisateur($idUtilisateur);
                    else {
                        $id = strip_tags($_GET['id']);
                        throw new Exception("Identifiant de l'utilisateur '$id' non valide");
                    }
                }
                else
                    throw new Exception("Identifiant de sujet non défini");
            }
            
            else if($_GET['action'] == 'supprimerForum') 
            {
                if ((isset($_GET['id'])) and (isset($_GET['catId']))) 
                {
                    if(isset($_SESSION['idUtilisateur']))
                    {
                        $idCategorie = intval($_GET['catId']);
                        $idForum = intval($_GET['id']);
                        $nbForumsRestant = $this->ctrlForum->compterForumsCategorie($idCategorie);
                        if($nbForumsRestant['nbForumsRestant'] > 1) 
                        {
                            $this->ctrlForum->supprimerForum($idForum);
                            $this->ctrlForum->listerForumsAvecCategories();
                        }
                        else 
                        {
                            $_SESSION['erreur'] = "Vous ne pouvez pas supprimer tous les forums d'une catégorie";
                            $this->ctrlForum->listerForumsAvecCategories();
                        }
                    
                    }
                    else
                        $this->ctrlUtilisateur->afficherConnexion();
                }
                else
                    throw new Exception("Identifiants  non défini");
            }
            
            else if($_GET['action'] == 'supprimerSujet') {
                if ((isset($_GET['id'])) and (isset($_GET['idForum']))) 
                {
                if(isset($_SESSION['idUtilisateur'])){
                    $idForum = intval($_GET['idForum']);
                    $idSujet = intval($_GET['id']);
                    $nbSujetsRestant = $this->ctrlSujet->compterSujetsForum($idForum);
                    if($nbSujetsRestant['nbSujetsRestant'] > 1) {
                        $this->ctrlSujet->supprimerSujet($idSujet);
                        $this->ctrlSujet->listerSujetsForum($idForum);
                    }
                    else {
                        $_SESSION['erreur'] = "Vous ne pouvez pas supprimer tous les sujets d'un forum";
                        $this->ctrlSujet->listerSujetsForum($idForum);
                    }
                }
                else
                    $this->ctrlUtilisateur->afficherConnexion();
            }
            else
                throw new Exception("Identifiants  non défini");
            }
                
            
            else if($_GET['action'] == 'supprimerMessage') {
                if ((isset($_GET['id'])) and (isset($_GET['idSujet']))) {
                if(isset($_SESSION['idUtilisateur'])){
                    $idSujet = intval($_GET['idSujet']);
                    $idMessage = intval($_GET['id']);
                    $nbMessagesRestant = $this->ctrlMessage->compterMessagesSujet($idSujet);
                    if($nbMessagesRestant['nbMessagesRestant'] > 1) {
                        $this->ctrlMessage->supprimerMessage($idMessage);
                        $this->ctrlMessage->listerMessagesSujet($idSujet);
                    }
                    else {
                        $_SESSION['erreur'] = "Vous ne pouvez pas supprimer tous les messages d'un sujet";
                        $this->ctrlMessage->listerMessagesSujet($idSujet);
                    }
                }
                else
                    $this->ctrlUtilisateur->afficherConnexion();
            }
            else
                throw new Exception("Identifiants  non défini");
            }
            
            else if($_GET['action'] == 'deconnecterUtilisateur') {
                $this->ctrlUtilisateur->deconnecterUtilisateur();
                $this->ctrlForum->listerForumsAvecCategories();
            }
            
            else if($_GET['action'] == 'nouveauForum') {
                if(isset($_SESSION['idUtilisateur']))
                    $this->ctrlForum->afficherNouveauForum();
                else
                    $this->ctrlUtilisateur->afficherConnexion();
            }
            
            else if($_GET['action'] == 'nouveauSujet') {
                if(isset($_SESSION['idUtilisateur']))
                    $this->ctrlSujet->afficherNouveauSujet();
                else 
                    $this->ctrlUtilisateur->afficherConnexion();  
            }
            
            else if($_GET['action'] == 'afficherInscription') {
                if(!isset($_SESSION['idUtilisateur']))
                    $this->ctrlUtilisateur->afficherInscription();
                else
                    $this->ctrlForum->listerForumsAvecCategories ();
            }
                
            else if($_GET['action'] == 'afficherConnexion') {
                if(!isset($_SESSION['idUtilisateur']))
                    $this->ctrlUtilisateur->afficherConnexion();
                else
                    $this->ctrlForum->listerForumsAvecCategories (); 
            }
            
            else
                throw new Exception("Aucune action définie");
        }
        
        else
            throw new Exception("Aucune action définie");
    }
}