<?php

require_once 'Modele/ModeleForum.php';
require_once 'Modele/ModeleCategorie.php';
require_once 'Modele/ModeleUtilisateur.php';
require_once 'Controleur/Controleur.php';

/**
 * Contrôleur des actions liées aux forums
 *
 * @author thibaultfloquet
 */
class ControleurForum extends Controleur
{
    private $modeleCategorie;
    private $modeleForum;
    private $modeleUtilisateur;
    private $modeleSujet;
    private $modeleMessage;

    public function __construct()
    {
        $this->modeleCategorie = new ModeleCategorie();
        $this->modeleForum = new ModeleForum();
        $this->modeleUtilisateur = new ModeleUtilisateur();
        $this->modeleSujet = new ModeleSujet();
        $this->modeleMessage = new ModeleMessage();
    }
    
    public function listerForumsAvecCategories()
    {
        $categories = $this->modeleCategorie->lireToutesLesCategories();
        $forums = $this->modeleForum->lireToutLesForums();
        $nbUtilisateurs = $this->modeleUtilisateur->compterNombreUtilisateurs();
        $dernierUtilisateur = $this->modeleUtilisateur->dernierUtilisateurInscrit();
        $nbMessages = $this->modeleMessage->compterNombreTotalMessages();
        $nbSujets = $this->modeleSujet->compterNombreTotalSujets();
        
        $resultatCategories = $categories->fetchAll();
        $resultatForums = $forums->fetchAll();
        
        foreach ($resultatForums as &$forum) // TODO Améliorer
        {
            $nbMessagesForum = $this->modeleForum->compterNombreDeMessagesForum($forum['NUMFORUM']);
            $nbSujetsForum = $this->modeleForum->compterNombreDeSujetsForum($forum['NUMFORUM']);
            $dernierMessage = $this->modeleForum->recupererDernierMessageForum($forum['NUMFORUM']);
            $forum['nbMessagesForum'] = $nbMessagesForum['nbMessagesForum'];
            $forum['nbSujetsForum'] = $nbSujetsForum['nbSujetsForum'];
            $forum['pseudoDernierMessage'] = $dernierMessage['PSEUDOUTILISATEUR'];
            $forum['numUtilisateurDernierMessage'] = $dernierMessage['NUMUTILISATEUR'];
            $forum['dateDernierMessage'] = $dernierMessage['DATECREATIONMESSAGE'];
            
            $dateNonFormatDernierMessage = strtotime($forum['dateDernierMessage']);
            $dateFormatDernierMessage['dateFormatDernierMessage'] = date('d M Y à H\hi', $dateNonFormatDernierMessage);
            
            $forum['dateDernierMessage'] = $dateFormatDernierMessage['dateFormatDernierMessage'];
        }
        
        $lienSuppression = "index.php?action=supprimerForum&id=";
        $lienSujets = "index.php?action=afficherSujets&id=";
        $lienUtilisateur = "index.php?action=afficherUtilisateur&id=";
        if(isset($_SESSION['idUtilisateur']))
            $lienAjoutForum = "index.php?action=nouveauForum";
        else 
            $lienAjoutForum = "index.php?action=afficherConnexion";
        
        $this->genererVue('listeForums', 
                array('categories' => $resultatCategories,
                    'forums' => $resultatForums ,
                    'nbUtilisateurs' => $nbUtilisateurs,
                    'nbSujets' => $nbSujets ,
                    'nbMessages' => $nbMessages,
                    'dernierUtilisateur' => $dernierUtilisateur,
                    'lienSujets' => $lienSujets,
                    'lienUtilisateur' => $lienUtilisateur,
                    'lienAjoutForum' => $lienAjoutForum,
                    'lienSuppression' => $lienSuppression));
    }
    
    public function afficherNouveauForum()
    {
        $categories = $this->modeleCategorie->lireToutesLesCategories();
        $this->genererVue('nouveauForum',
                array('categories' => $categories));
    }
    
    public function ajouterForumAffichage($nomF, $desc, $cat)
    {
        $this->modeleForum->ajouterForum($nomF, $desc, $cat);
        $this->listerForumsAvecCategories();
    }
    
    public function ajouterForum($nomF, $desc, $cat)
    {
        $this->modeleForum->ajouterForum($nomF, $desc, $cat);
    }
    
    public function supprimerForum($numForum)
    {
        $this->modeleForum->supprimerForum($numForum);
    }

        public function recupererDernierForumInsert()
    {
        $dernierInsert = $this->modeleForum->dernierForumInsert();
        return $dernierInsert['lid'];
    }
    
    public function compterForumsCategorie($id)
    {
        return $this->modeleForum->compterForumsCategorie($id); 
    }
}