/*==============================================================*/
/* Nom de SGBD :  MySQL 5.0                                     */
/* Date de cr�ation :  20/12/2012 09:13:00                      */
/*==============================================================*/

drop table if exists MESSAGE;

drop table if exists SUJET;

drop table if exists FORUM;

drop table if exists UTILISATEUR;

drop table if exists DROIT;

drop table if exists CATEGORIE;

/*==============================================================*/
/* Table : CATEGORIE                                            */
/*==============================================================*/
create table CATEGORIE
(
    NUMCATEGORIE    int(3) not null AUTO_INCREMENT,
    TITRECATEGORIE  varchar(100),
    primary key (NUMCATEGORIE)
)ENGINE=INNODB CHARACTER SET utf8 COLLATE utf8_general_ci;


/*==============================================================*/
/* Table : FORUM                                                */
/*==============================================================*/
create table FORUM
(
   NUMFORUM             int(3) not null AUTO_INCREMENT,
   TITREFORUM           varchar(100),
   DESCRIPTIONFORUM     text,
   DATECREATIONFORUM    date,
   NUMUTILISATEUR       int(3) not null,
   NUMCATEGORIE         int(3) not null,
   primary key (NUMFORUM)
)ENGINE=INNODB CHARACTER SET utf8 COLLATE utf8_general_ci;

/*==============================================================*/
/* Table : MESSAGE                                              */
/*==============================================================*/
create table MESSAGE
(
   NUMMESSAGE           int(3) not null AUTO_INCREMENT,
   NUMUTILISATEUR       int(3) not null,
   NUMSUJET             int(3) not null,
   CONTENUMESSAGE       text,
   DATECREATIONMESSAGE  datetime,
   primary key (NUMMESSAGE)
)ENGINE=INNODB CHARACTER SET utf8 COLLATE utf8_general_ci;

/*==============================================================*/
/* Table : SUJET                                                */
/*==============================================================*/
create table SUJET
(
   NUMSUJET             int(3) not null AUTO_INCREMENT,
   NUMFORUM             int(3) not null,
   NUMUTILISATEUR       int(3) not null,
   TITRESUJET           varchar(100),
   DATECREATIONSUJET    datetime,
   NBCONSULTATIONSSUJET int(4),
   primary key (NUMSUJET)
)ENGINE=INNODB CHARACTER SET utf8 COLLATE utf8_general_ci;

/*==============================================================*/
/* Table : UTILISATEUR                                          */
/*==============================================================*/
create table UTILISATEUR
(
   NUMUTILISATEUR       int(3) not null AUTO_INCREMENT,
   PSEUDOUTILISATEUR    varchar(100),
   MDPUTILISATEUR       varchar(20),
   EMAILUTILISATEUR     varchar(100),
   DATEINSCRIPTION      datetime,
   NUMDROIT             int(2),
   primary key (NUMUTILISATEUR)
)ENGINE=INNODB CHARACTER SET utf8 COLLATE utf8_general_ci;

/*==============================================================*/
/* Table : DROIT                                          */
/*==============================================================*/
create table DROIT
(
   NUMDROIT       int(2) not null AUTO_INCREMENT,
   LIBELLEDROIT   varchar(50),
   primary key (NUMDROIT)
)ENGINE=INNODB CHARACTER SET utf8 COLLATE utf8_general_ci;

alter table MESSAGE add constraint FK_MESSAGE_SUJET foreign key (NUMSUJET)
      references SUJET (NUMSUJET) on delete cascade on update restrict;

alter table MESSAGE add constraint FK_MESSAGE_UTLIISATEUR foreign key (NUMUTILISATEUR)
      references UTILISATEUR (NUMUTILISATEUR) on delete cascade on update restrict;

alter table SUJET add constraint FK_SUJET_FORUM foreign key (NUMFORUM)
      references FORUM (NUMFORUM) on delete cascade on update restrict;

alter table SUJET add constraint FK_SUJET_UTILISATEUR foreign key (NUMUTILISATEUR)
      references UTILISATEUR (NUMUTILISATEUR) on delete cascade on update restrict;

alter table FORUM add constraint FK_FORUM_UTILISATEUR foreign key (NUMUTILISATEUR)
      references UTILISATEUR (NUMUTILISATEUR) on delete cascade on update restrict;

alter table FORUM add constraint FK_FORUM_CATEGORIE foreign key (NUMCATEGORIE)
      references CATEGORIE (NUMCATEGORIE) on delete cascade on update restrict;

alter table UTILISATEUR add constraint FK_UTILISATEUR_DROIT foreign key (NUMDROIT)
      references DROIT (NUMDROIT) on delete cascade on update restrict;

